/* move an object-instance to another, change colors of both while they collide */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>

int main(int argc, char **argv) {
  unsigned int coll_tag;
  const int coll_percent = 100;
  int winw, winh, canz, i1;
  struct VG_Coll *collp;
  struct VG_Rect rect1, rect2;
  unsigned int instanceid1, instanceid2;
  int color1, color2;

  (void)argc; (void)argv;

  /* initialize and open window */
  if (!VG_init("test")) { exit(1); }
  if (!vg4->window->open(VG_WINDOW_SIZE_LOW, VG_WINDOW_SCALE_BEST)) { VG_dest(); exit(1); }
  vg4->window->getsize(&winw, &winh);

  /* create two object-instances */
  instanceid1 = 1;
  rect1.x = 0; rect1.w = 20;
  rect1.y = winh / 2 - 5; rect1.h = 20;
  color1 = VG_COLOR_RED;
  instanceid2 = 2;
  rect2.x = winw / 2; rect2.w = 20;
  rect2.y = winh / 2; rect2.h = 20;
  color2 = VG_COLOR_GREEN;

  /* create collision-tag */
  coll_tag = vg4->collision->create(NULL, 0, 0);

  /* insert object-instances into collision-tag */
  vg4->collision->insert(coll_tag, instanceid1, &rect1, coll_percent);
  vg4->collision->insert(coll_tag, instanceid2, &rect2, coll_percent);

  /* game loop */
  for (;;) {
    if (!vg4->input->update(VG_TRUE)) { break; }

    vg4->window->clear();

    /* move first object-instance */
    if (++rect1.x == winw) { break; }

    /* update position and get collisions of first object-instance */
    canz = vg4->collision->setpos(coll_tag, instanceid1, &rect1, &collp);
    for (i1 = 0; i1 < canz; i1++) {
      if (collp[i1].type == VG_COLL_TYPE_ENTRY) {  /* entering into collision */
        /* change colors to yellow and white */
        color1 = VG_COLOR_YELLOW;
        color2 = VG_COLOR_WHITE;
      } else if (collp[i1].type == VG_COLL_TYPE_LEAVE) {  /* leaving collision */
        /* reset colors to default */
        color1 = VG_COLOR_RED;
        color2 = VG_COLOR_GREEN;
      }
    }
    if (collp != NULL) { free(collp); }

    /* draw object-instances */
    vg4->window->draw_rect(&rect1, color1, VG_TRUE);
    vg4->window->draw_rect(&rect2, color2, VG_TRUE);

    vg4->window->flush();
    vg4->misc->wait_time(30);
  }

  /* destroy and exit */
  VG_dest();
  exit(0);
}
